<?php
/**
 * License Administration Template
 *
 * @link       https://ardisplay.com
 * @since      1.0.0
 *
 * @package    ardisplay
 * @subpackage ardisplay/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get the current license key
$api_key = AR_Display_api_key_Helper::get_api_key();
$has_license = !empty($api_key);
?>

<div class="wrap ardisplay-license-wrapper">
    <h1><?php echo esc_html__('ardisplay API Integration', 'ardisplay'); ?></h1>
    
    <div class="ardisplay-admin-box">
        <h2><?php echo esc_html__('API Key', 'ardisplay'); ?></h2>
        
        <p>
            <?php echo esc_html__('Enter your API    key to enable API integration and premium features.', 'ardisplay'); ?>
        </p>
        
        <div class="ardisplay-license-form">
            <div class="ardisplay-license-input">
                <input type="text"
                    id="ardisplay-api-key"
                    name="ardisplay_api_key"
                    class="regular-text"
                    value="<?php echo $has_license ? esc_attr($api_key) : ''; ?>"
                    placeholder="<?php echo esc_attr__('Enter your API key', 'ardisplay'); ?>"
                >
                
                <?php if ($has_license): ?>
                    <button type="button" id="ardisplay-toggle-api-key" class="button button-secondary">
                        <span class="dashicons dashicons-visibility"></span>
                    </button>
                    <?php endif; ?>
                </div>
                <div id="ardisplay-api-key-message" style="display: none; color: red;"></div>
            
            <div class="ardisplay-license-actions">
                <button type="button" id="ardisplay-save-api-key" class="button button-primary">
                    <?php echo $has_license ? esc_html__('Update API Key', 'ardisplay') : esc_html__('Save API Key', 'ardisplay'); ?>
                </button>
            </div>
            
        </div>
    </div>
    
    <div class="ardisplay-admin-box">
        <h2><?php echo esc_html__('ardisplay API Integration', 'ardisplay'); ?></h2>
        
        <p>
            <?php echo esc_html__('With a valid license key, you can access the ardisplay API features:', 'ardisplay'); ?>
        </p>
        
        <ul class="ardisplay-feature-list">
            <li>
                <span class="dashicons dashicons-yes"></span>
                <?php echo esc_html__('Upload 3D models to the ardisplay cloud', 'ardisplay'); ?>
            </li>
            <li>
                <span class="dashicons dashicons-yes"></span>
                <?php echo esc_html__('Multiple model variants for different product options', 'ardisplay'); ?>
            </li>
            <li>
                <span class="dashicons dashicons-yes"></span>
                <?php echo esc_html__('Advanced AR button customization', 'ardisplay'); ?>
            </li>
            <li>
                <span class="dashicons dashicons-yes"></span>
                <?php echo esc_html__('Analytics for user engagement with AR content', 'ardisplay'); ?>
            </li>
        </ul>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Toggle license visibility
    $('#ardisplay-toggle-api-key').on('click', function() {
        var licenseField = $('#ardisplay-api-key');
        var fieldType = licenseField.attr('type');
        
        if (fieldType === 'password') {
            licenseField.attr('type', 'text');
            $(this).find('.dashicons').removeClass('dashicons-visibility').addClass('dashicons-hidden');
        } else {
            licenseField.attr('type', 'password');
            $(this).find('.dashicons').removeClass('dashicons-hidden').addClass('dashicons-visibility');
        }
    });
    
    // Save/Update API key
    $('#ardisplay-save-api-key').on('click', function() {
        var apiKey = $('#ardisplay-api-key').val().trim();
        var messageDiv = $('#ardisplay-api-key-message');
        
        if (apiKey === '') {
            messageDiv.html('<p class="error"><?php echo esc_js(__('Please enter an API key.', 'ardisplay')); ?></p>').show();
            return;
        }
        
        // Show loading state
        $(this).prop('disabled', true).html('<?php echo esc_js(__('Saving...', 'ardisplay')); ?>');
        messageDiv.hide();
        
        // Send AJAX request to save license
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'ardisplay_save_api_key',
                api_key: apiKey,
                nonce: '<?php echo wp_create_nonce('ardisplay_api_key_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    ardisplayToastrSuccess(response.data.message);
                } else {
                    ardisplayToastrError(response.data.message);
                }
            },
            error: function() {
                ardisplayToastrError('<?php echo esc_js(__('An error occurred. Please try again.', 'ardisplay')); ?>');
            },
            complete: function() {
                // Reset button state
                var saveButton = $('#ardisplay-save-api-key');
                var buttonText = apiKey !== '' ? '<?php echo esc_js(__('Update API Key', 'ardisplay')); ?>' : '<?php echo esc_js(__('Save API Key', 'ardisplay')); ?>';
                saveButton.prop('disabled', false).html(buttonText);
            }
        });
    });
});
</script>

<style>

.ardisplay-admin-box {
    background: #fff;
    border: 1px solid #ccd0d4;
    box-shadow: 0 1px 1px rgba(0,0,0,0.04);
    margin-bottom: 20px;
    padding: 20px;
}

.ardisplay-license-form {
    margin-top: 20px;
}

.ardisplay-license-input {
    display: flex;
    margin-bottom: 15px;
}

.ardisplay-license-input input {
    flex: 1;
}

.ardisplay-license-input button {
    margin-left: 5px;
}

.ardisplay-license-actions {
    margin-bottom: 15px;
}

.ardisplay-feature-list {
    margin-top: 15px;
}

.ardisplay-feature-list li {
    margin-bottom: 8px;
    display: flex;
    align-items: center;
}

.ardisplay-feature-list .dashicons {
    color: #46b450;
    margin-right: 10px;
}

#ardisplay-api-key-message {
    margin-top: 15px;
}
</style>
