<?php if (!defined('ABSPATH')) exit; ?>
<script type="text/javascript">
jQuery(document).ready(function($) {
    // Store 3D model data
    window.store3DModel = async function(modelData) {
        try {
            // Show loading state
            $('#save_model_btn').prop('disabled', true).html('Saving...');
            
            // Prepare and send the request using $.ajax with form-encoded data
            return new Promise((resolve, reject) => {
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'ardisplay_store_3d_model',
                        nonce: '<?php echo wp_create_nonce('ardisplay_3d_model_nonce'); ?>',
                        model_data: JSON.stringify(modelData) // Stringify the model data but send as form field
                    },
                    success: function(result) {
                        if (!result.success) {
                            console.error('Error storing 3D model:', result);
                            reject(new Error(result.data ? (result.data.message || 'Failed to save model') : 'Failed to save model'));
                            return;
                        }
                        
                        resolve({
                            success: true,
                            model_id: result.data.model_id,
                            message: result.data.message || 'Model saved successfully'
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error storing 3D model:', error, xhr.responseText);
                        reject(new Error(error || 'An error occurred while saving the model'));
                    },
                    complete: function() {
                        // Reset button state
                        $('#save_model_btn').prop('disabled', false).html('<?php echo esc_js(__('Save Model', 'ardisplay')); ?>');
                    }
                });
            });
        } catch (error) {
            console.error('Error storing 3D model:', error);
            $('#save_model_btn').prop('disabled', false).html('<?php echo esc_js(__('Save Model', 'ardisplay')); ?>');
            return {
                success: false,
                message: error.message || 'An error occurred while saving the model'
            };
        }
    };
    
    // Update 3D model data
    window.update3DModel = async function(modelId, modelData) {
        try {
            // Show loading state
            $('#save_model_btn').prop('disabled', true).html('Updating...');
            
            // Prepare and send the request using $.ajax with form-encoded data
            return new Promise((resolve, reject) => {
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'ardisplay_update_3d_model',
                        nonce: '<?php echo wp_create_nonce('ardisplay_3d_model_nonce'); ?>',
                        model_id: modelId,
                        model_data: JSON.stringify(modelData) // Stringify the model data but send as form field
                    },
                    success: function(result) {
                        if (!result.success) {
                            reject(new Error(result.data ? (result.data.message || 'Failed to update model') : 'Failed to update model'));
                            return;
                        }
                        
                        resolve({
                            success: true,
                            model_id: result.data.model_id,
                            message: result.data.message || 'Model updated successfully'
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error updating 3D model:', error, xhr.responseText);
                        reject(new Error(error || 'An error occurred while updating the model'));
                    },
                    complete: function() {
                        // Reset button state
                        $('#save_model_btn').prop('disabled', false).html('<?php echo esc_js(__('Update Model', 'ardisplay')); ?>');
                    }
                });
            });
        } catch (error) {
            console.error('Error updating 3D model:', error);
            $('#save_model_btn').prop('disabled', false).html('<?php echo esc_js(__('Update Model', 'ardisplay')); ?>');
            return {
                success: false,
                message: error.message || 'An error occurred while updating the model'
            };
        }
    };

    window.verifyFileExists = async function(url) {
        if (!url) return false;
        
        try {
            // Use $.ajax instead of fetch for HEAD request
            return new Promise((resolve) => {
                $.ajax({
                    url: url,
                    type: 'HEAD',
                    success: function() {
                        resolve(true);
                    },
                    error: function() {
                        resolve(false);
                    }
                });
            });
        } catch (error) {
            console.error('Error verifying file exists:', error);
            return false;
        }
    };
    
    // Function to handle form submission
    window.submitModelForm = async function(formData, variantsData, isEdit = false) {
        try {
            if (!variantsData || !Array.isArray(variantsData) || variantsData.length === 0) {
                ardisplayToastrError('<?php echo esc_js(__('At least one variant is required', 'ardisplay')); ?>');
                return;
            }

            // Validate required fields
            if (!formData.title) {
                ardisplayToastrError('<?php echo esc_js(__('Title is required', 'ardisplay')); ?>');
                return;
            }
            
            if (!formData.description) {
                ardisplayToastrError('<?php echo esc_js(__('Description is required', 'ardisplay')); ?>');
                return;
            }
            
            if (!formData.addToCartUrl) {
                ardisplayToastrError('<?php echo esc_js(__('Add to Cart URL is required', 'ardisplay')); ?>');
                return;
            }
            
            if (!formData.url) {
                ardisplayToastrError('<?php echo esc_js(__('Model URL is required', 'ardisplay')); ?>');
                return;
            }


            
            // Format the data according to Prisma schema
            const modelData = {
                title: formData.title,
                description: formData.description || '',
                addToCartUrl: formData.addToCartUrl || '',
                url: formData.url || '',
                product_id: formData.product_id || '',
                variants: variantsData.map(variant => ({
                    model: variant.androidId || '',
                    name: variant.name || '',
                    url: variant.url || '',
                    posterFileUrl: variant.posterFileUrl || '',
                    placement: variant.placement || 'floor',
                    iosUrl: variant.iosUrl || '',
                    iosId: variant.iosId || '',
                    androidId: variant.androidId || '',
                    posterFileId: variant.posterFileId || '',
                    sizes: Array.isArray(variant.sizes) ? variant.sizes.map(size => ({
                        label: size.label || '',
                        width: parseFloat(size.width) || 0,
                        height: parseFloat(size.height) || 0,
                        depth: parseFloat(size.depth) || 0
                    })) : []
                }))
            };
            
            let result;
            if (isEdit && formData.id) {
                // Update existing model
                result = await window.update3DModel(formData.id, modelData);
            } else {
                // Store new model
                result = await window.store3DModel(modelData);
            }
            
            if (result.success) {
                ardisplayToastrSuccess(result.message);
                
                if (!isEdit && !formData.product_id) {
                    window.location.href = '<?php echo esc_js(admin_url('admin.php?page=ardisplay-models')); ?>';
                } else {
                    window.location.href = '<?php echo esc_js(admin_url('admin.php?page=display-products-page')); ?>';
                }
            } else {
                ardisplayToastrError(`<?php echo esc_js(__('Error', 'ardisplay')); ?>: ${result.message}`);
            }
        } catch (error) {
            console.error('Error submitting model form:', error);
            ardisplayToastrError(`<?php echo esc_js(__('An unexpected error occurred', 'ardisplay')); ?>: ${error.message}`);
        }
    };
    
    // Form submission handler
    $('#save_model_btn').on('click', function(e) {
        e.preventDefault();
        
        // Get the form data
        const formData = {
            id: $('input[name="record_id"]').val(),
            product_id: $('input[name="product_id"]').length ? $('input[name="product_id"]').val() : '',
            title: $('#model_title').val(),
            description: $('#model_description').val(),
            url: $('#model_url').val(),
            addToCartUrl: $('#addToCartUrl').val(),
            return_url: '<?php echo admin_url('admin.php?page=ardisplay'); ?>'
        };
        
        // Get all models from the table
        const variantsData = [];
        const rows = $('#uploadedModelsTable tbody tr').not('.no-items');
        
        rows.each(function() {
            const rowData = $(this).data('model');
            if (rowData) {
                variantsData.push(rowData);
            }
        });
        
        // Submit the form
        window.submitModelForm(formData, variantsData, !!formData.id);
    });
    
    // Initialize form submission if elements exist
    if ($('#ardisplay-model-form').length > 0) {
        $('#ardisplay-model-form').on('submit', function(e) {
            e.preventDefault();
            
            const form = $(this);
            const formData = {
                title: form.find('[name="model_title"]').val(),
                description: form.find('[name="model_description"]').val(),
                url: form.find('[name="addToCartUrl"]').val(),
                scale: parseFloat(form.find('[name="model_scale"]').val()) || 1.0,
                product_id: form.find('[name="product_id"]').val(),
                id: form.find('[name="model_id"]').val(),
                return_url: form.find('[name="return_url"]').val()
            };
            
            const isEdit = !!formData.id;
            
            // Use the global variants data that should be set by the variant management interface
            if (typeof window.modelVariants !== 'undefined') {
                window.submitModelForm(formData, window.modelVariants, isEdit);
            } else {
                ardisplayToastrError('<?php echo esc_js(__('No variant data found. Please add at least one variant.', 'ardisplay')); ?>');
            }
        });
    }
});
</script>
