<?php if (!defined('ABSPATH')) exit; ?>
<script type="module">
    // Global variables for model handling
    let finalGLBBlob = null;
    let finalUSDZBlob = null;
    let uploadXhr = null;
    let uploadedModelSizes = [];
    let modelCounter = 0;
    let isUploading = false;
    let currentFileType = "";
    let currentFrameIndex = 0;
    let generatedModelUrl = "";
    let uploadedFile = null;
    let selectedFrameStyle = null;

    // Define functions first and immediately add them to window object
    function setupModelViewer(modelUrl, showFrameButtons) {
        var viewerContainer = document.getElementById("modelViewer");
        viewerContainer.innerHTML = "";
        var modelViewer = document.createElement("model-viewer");
        modelViewer.setAttribute("src", modelUrl);
        modelViewer.setAttribute("ar", "");
        modelViewer.setAttribute("autoplay", "");
        modelViewer.setAttribute("camera-controls", "");
        modelViewer.style.width = "100%";
        modelViewer.style.height = "400px";
        viewerContainer.appendChild(modelViewer);
        
        var actions = document.getElementById("modelActions");
        actions.style.display = "block";
        
        const closeBtn = document.getElementById("closeModelBtnStep4");
        closeBtn.textContent = "Back";
        closeBtn.onclick = function() {
            window.showStep(1);
        };
        
        var frameButtons = document.getElementById("frameButtonsContainer");
        frameButtons.style.display = showFrameButtons ? "flex" : "none";
    }
    window.setupModelViewer = setupModelViewer;

    function generateFrameButtons(texture, baseTextureSrc) {
        var container = document.getElementById("frameButtonsContainer");
        container.innerHTML = "";
        
        // Initialize selectedFrameStyle if not already set
        window.selectedFrameStyle = window.selectedFrameStyle || window.FRAME_STYLES[0];

        window.FRAME_STYLES.forEach(function(frameStyle, index) {
            var btn = document.createElement("button");
            btn.type = "button";
            btn.innerText = frameStyle.name;
            // Set active class based on currentFrameIndex
            btn.className = frameStyle === window.selectedFrameStyle ? "active" : "";
            btn.onclick = function() {
                container.querySelectorAll("button").forEach(button => {
                    button.classList.remove("active");
                });
                btn.classList.add("active");
                currentFrameIndex = index;
                window.selectedFrameStyle = frameStyle;
                
                const textureLoader = new THREE.TextureLoader();
                textureLoader.load(baseTextureSrc, function(newTexture) {
                    window.createGLBModel(newTexture, window.selectedFrameStyle)
                        .then(function(glbOutput) {
                            window.finalGLBBlob = new Blob([glbOutput], { type: "model/gltf-binary" });
                            window.generatedModelUrl = URL.createObjectURL(window.finalGLBBlob);
                            window.setupModelViewer(window.generatedModelUrl, true);
                        })
                        .catch(function(error) { alert("Error updating frame: " + error); });
                });
            };
            container.appendChild(btn);
        });
    }
    window.generateFrameButtons = generateFrameButtons;

    function showPreviewModal(modelUrl) {
        const previewModal = document.getElementById('previewModal');
        const previewContainer = document.getElementById('previewModelViewer');
        const sizeButtonsContainer = document.getElementById('previewSizeButtons');
        const closeBtn = document.getElementById('closePreviewBtn');
        const closeX = previewModal.querySelector('.close');

        // Create model viewer
        previewContainer.innerHTML = '';
        const modelViewer = document.createElement('model-viewer');
        modelViewer.setAttribute('src', modelUrl);
        modelViewer.setAttribute('ar', '');
        modelViewer.setAttribute('auto-rotate', '');
        modelViewer.setAttribute('camera-controls', '');
        modelViewer.style.width = '100%';
        modelViewer.style.height = '100%';
        previewContainer.appendChild(modelViewer);

        // Find the row with this model URL and get its sizes
        const modelRow = document.querySelector(`#uploadedModelsTable tr [data-url="${modelUrl}"]`).closest('tr');
        const sizes = modelRow.dataset.sizes ? JSON.parse(modelRow.dataset.sizes) : [];

        // Create size buttons
        sizeButtonsContainer.innerHTML = '';
        if (sizes.length > 0) {
            sizes.forEach((size, index) => {
                const button = document.createElement('button');
                button.className = 'size-button';
                button.textContent = size.label || `Size ${index + 1}`; // Only show the label
                button.onclick = async () => {
                    // Remove active class from all buttons
                    sizeButtonsContainer.querySelectorAll('.size-button').forEach(btn => {
                        btn.classList.remove('active');
                    });
                    // Add active class to clicked button
                    button.classList.add('active');
                    
                    try {
                        const scale = await window.getScaleForSize(modelUrl, {
                            width: size.width,
                            height: size.height,
                            depth: size.depth
                        });
                        modelViewer.scale = `${scale.x} ${scale.y} ${scale.z}`;
                    } catch(e) {
                        console.error('Error applying size:', e);
                    }
                };
                sizeButtonsContainer.appendChild(button);
            });

            // Trigger click on first size button
            sizeButtonsContainer.querySelector('.size-button').click();
        }

        // Show modal
        previewModal.style.display = 'flex';

        // Close handlers
        const closeModal = () => {
            previewModal.style.display = 'none';
            previewContainer.innerHTML = '';
            sizeButtonsContainer.innerHTML = '';
        };

        closeBtn.onclick = closeModal;
        closeX.onclick = closeModal;
        window.onclick = function(event) {
            if (event.target == previewModal) {
                closeModal();
            }
        };
    }
    window.showPreviewModal = showPreviewModal;

    function addSizeRow(defaultDimensions = null) {
        var container = document.querySelector("#sizeRowsContainer tbody");
        var newRow = document.createElement("tr");
        newRow.className = "size-row";
        newRow.innerHTML = `
            <td><input type="text" class="dimLabel" placeholder="Size label" value="${defaultDimensions?.label || ''}"></td>
            <td><input type="number" class="dimWidth" placeholder="Width" value="${defaultDimensions ? defaultDimensions.width : ''}"></td>
            <td><input type="number" class="dimHeight" placeholder="Height" value="${defaultDimensions ? defaultDimensions.height : ''}"></td>
            <td><input type="number" class="dimDepth" placeholder="Depth" value="${defaultDimensions ? defaultDimensions.depth : ''}"></td>
            <td>

                <button type="button" class="previewSize button-link">Preview</button> |
                <button type="button" class="removeSizeRow ">Remove</button>
            </td>
        `;
        container.appendChild(newRow);
        newRow.querySelector(".removeSizeRow").onclick = function() { container.removeChild(newRow); };
        newRow.querySelector(".previewSize").onclick = async function() {
            const width = parseFloat(newRow.querySelector(".dimWidth").value);
            const height = parseFloat(newRow.querySelector(".dimHeight").value);
            const depth = parseFloat(newRow.querySelector(".dimDepth").value);
            
            if (isNaN(width) || isNaN(height) || isNaN(depth)) {
                alert("Please enter valid numeric dimensions");
                return;
            }

            const sizeInputs = { 
                width: width, 
                height: height, 
                depth: depth 
            };

            const modelViewer = document.querySelector("#modelViewerStep5 model-viewer");
            if (!modelViewer) {
                console.error("Model viewer not found");
                return;
            }

            try {
                const scale = await window.getScaleForSize(modelViewer.src, sizeInputs);
                if (scale) {
                    modelViewer.scale = `${scale.x} ${scale.y} ${scale.z}`;
                    console.log("Applied scale:", scale);
                }
            } catch(e) { 
                console.error("Scaling error:", e);
                alert("Error applying dimensions");
            }
        };
    }
    window.addSizeRow = addSizeRow;

    // Export variables to window
    window.finalGLBBlob = finalGLBBlob;
    window.finalUSDZBlob = finalUSDZBlob;
    window.uploadXhr = uploadXhr;
    window.uploadedModelSizes = uploadedModelSizes;
    window.modelCounter = modelCounter;
    window.isUploading = isUploading;
    window.currentFileType = currentFileType;
    window.currentFrameIndex = currentFrameIndex;
    window.generatedModelUrl = generatedModelUrl;
    window.uploadedFile = uploadedFile;
    window.selectedFrameStyle = selectedFrameStyle;
</script>
