<?php if (!defined('ABSPATH')) exit; ?>
<script type="module">
    // Add utility functions to window for global access
    window.uniqid = function(prefix = "", random = false) {
        const sec = Date.now() * 1000 + Math.random() * 1000;
        const id = sec.toString(16).replace(/\./g, "").padEnd(14, "0");
        return `${prefix}${id}${random ? `.${Math.trunc(Math.random() * 100000000)}` : ""}`;
    };

    window.getScaleForSize = function(glbUrl, size) {
        return new Promise((resolve, reject) => {
            try {
                const loader = new window.GLTFLoader();
                if (typeof window.DRACOLoader !== 'undefined') {
                    const dracoLoader = new window.DRACOLoader();
                    dracoLoader.setDecoderPath(
                        "https://www.gstatic.com/draco/versioned/decoders/1.5.6/"
                    );
                    loader.setDRACOLoader(dracoLoader);
                }

                // If MeshoptDecoder is available globally, attach it.
                if (window.MeshoptDecoder) {
                    loader.setMeshoptDecoder(window.MeshoptDecoder);
                }
                
                loader.load(
                    glbUrl,
                    (gltf) => {
                        const scene = gltf.scene;
                        const box = new THREE.Box3().setFromObject(scene);
                        const vecSize = new THREE.Vector3();
                        box.getSize(vecSize);

                        const desiredW = window.cmToMeters(size.width);
                        const desiredH = window.cmToMeters(size.height);
                        const desiredD = window.cmToMeters(size.depth);

                        const scaleX = desiredW / vecSize.x;
                        const scaleY = desiredH / vecSize.y;
                        const scaleZ = desiredD / vecSize.z;

                        resolve({ x: scaleX, y: scaleY, z: scaleZ });
                    },
                    undefined,
                    (err) => {
                        console.error('Error loading GLTF:', err);
                        reject(new Error("Could not load GLTF for scaling"));
                    }
                );
            } catch (e) {
                console.error('Error initializing loader:', e);
                reject(e);
            }
        });
    };

    window.cmToMeters = function(cmString) {
        return parseFloat(String(cmString).replace("cm", "")) / 100;
    };

    window.metersToString = function(meters) {
        return (meters * 100).toFixed(2);
    };

    window.getModelDimensions = async function(modelViewer) {
        const dimensions = modelViewer.getDimensions();
        return {
            width: window.metersToString(dimensions.x),
            height: window.metersToString(dimensions.y),
            depth: window.metersToString(dimensions.z)
        };
    };

    window.formatBytes = function(bytes) {
        if (bytes === 0) return "0 B";
        const k = 1024;
        const sizes = ["B", "KB", "MB", "GB", "TB"];
        const i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + " " + sizes[i];
    };
</script>
