<?php
/**
 * Plugin Name: AR Display
 * Plugin URI: https://ardisplay.net
 * Description: Display your products in 3D in the real world using ARDisplay. Boost engagement and reduce returns.
 * Version: 1.0.0
 * Author: ARDisplay Team
 * Author URI: https://prosoft.agency
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: ardisplay
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Define plugin constants
define('AR_DISPLAY_VERSION', '1.0.0');
define('AR_DISPLAY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AR_DISPLAY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ARDISPLAY_API_ENDPOINT', "https://ardisplay.net/api");
define('ASSETGER_API_ENDPOINT', ' https://c1.ardisplay.net/api');
define('ASSETGER_SECRET_KEY', 'TOcdsjs7PUNSyBmRpMLyb7HzY2s2aizA');


/**
 * The code that runs during plugin activation.
 */
function activate_ardisplay() {
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_ardisplay() {
    // Deactivation tasks
}

/**
 * Include the core plugin class
 */
require_once AR_DISPLAY_PLUGIN_DIR . 'includes/class-ardisplay.php';

/**
 * Include WordPress and WooCommerce helper functions
 */
require_once AR_DISPLAY_PLUGIN_DIR . 'includes/wp-functions.php';

/**
 * Begins execution of the plugin.
 */
function run_ardisplay() {
    $plugin = new AR_Display();
    $plugin->run();
}
function enqueue_admin_toastr_assets() {
    wp_register_style(
        'ardisplay-toastr',
        'https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css',
        array(),
        null
    );
    wp_register_script(
        'ardisplay-toastr',
        'https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js',
        array('jquery'),
        '2.1.4',
        true
    );
    wp_register_script(
        'ardisplay-toastr-notifications',
        AR_DISPLAY_PLUGIN_URL . 'admin/js/toastr-notifications.js',
        array('ardisplay-toastr'),
        AR_DISPLAY_VERSION,
        true
    );
    wp_enqueue_style('ardisplay-toastr');
    wp_enqueue_script('ardisplay-toastr');
    wp_enqueue_script('ardisplay-toastr-notifications');
}
add_action('admin_enqueue_scripts', 'enqueue_admin_toastr_assets');

// Run the plugin
run_ardisplay();
