// Removed import statements. The code now expects global THREE, GLTFLoader, DRACOLoader, USDZExporter, and MeshoptDecoder.

const THREE = window.THREE;
const GLTFLoader = window.GLTFLoader;
const DRACOLoader = window.DRACOLoader;
const USDZExporter = window.USDZExporter;
const GLTFExporter = window.GLTFExporter;

function createUSDZModelFromGLB(glbFile, anchoringAlignment = "horizontal") {
  // Create an object URL for the uploaded file.
  const url = URL.createObjectURL(glbFile);

  return new Promise(function (resolve, reject) {
    // Create a new GLTFLoader from the global THREE.
    var loader = new GLTFLoader();

    // If MeshoptDecoder is available globally, attach it.
    if (window.MeshoptDecoder) {
      loader.setMeshoptDecoder(window.MeshoptDecoder);
    }

    // Add DRACOLoader if available
    if (typeof DRACOLoader !== "undefined") {
      const dracoLoader = new DRACOLoader();
      dracoLoader.setDecoderPath(
        "https://www.gstatic.com/draco/versioned/decoders/1.5.6/"
      );
      loader.setDRACOLoader(dracoLoader);
    }

    loader.load(
      url,
      function (gltf) {
        // Revoke the object URL.
        URL.revokeObjectURL(url);

        // Traverse the loaded scene to update materials.
        gltf.scene.traverse(function (child) {
          if (child.isMesh) {
            if (Array.isArray(child.material)) {
              child.material.forEach(function (material) {
                if (material.side === THREE.DoubleSide) {
                  material.side = THREE.FrontSide;
                }
              });
            } else if (child.material) {
              if (child.material.side === THREE.DoubleSide) {
                child.material.side = THREE.FrontSide;
              }
            }
          }
        });

        var scene = gltf.scene;

        // For vertical anchoring, rotate the scene.
        if (anchoringAlignment === "vertical") {
          scene.rotation.x = -Math.PI / 2;
        }

        scene.updateMatrixWorld(true);

        var usdzExportOptions = {
          ar: {
            anchoring: { type: "plane" },
            planeAnchoring: { alignment: anchoringAlignment },
          },
          includeAnchoringProperties: true,
          quickLookCompatible: false,
          maxTextureSize: 1024,
        };

        // Use USDZExporter from global scope, falling back to THREE.USDZExporter if necessary.
        var ExporterConstructor = window.USDZExporter || THREE.USDZExporter;
        if (!ExporterConstructor) {
          return reject(new Error("USDZExporter is not available"));
        }
        var exporter = new ExporterConstructor();
        exporter.parse(
          scene,
          function (usdzArrayBuffer) {
            var filename = glbFile.name.replace(/\.[^/.]+$/, ".usdz");
            var usdzFile = new File([usdzArrayBuffer], filename, {
              type: "model/usdz",
            });
            resolve(usdzFile);
          },
          function (error) {
            reject(new Error(String(error)));
          },
          usdzExportOptions
        );
      },
      undefined,
      function (error) {
        URL.revokeObjectURL(url);
        reject(new Error(String(error)));
      }
    );
  });
}

// Expose the function globally.
window.createUSDZModelFromGLB = createUSDZModelFromGLB;
